package tech.ostack.kform.schemas

import kotlin.reflect.KClass
import kotlin.reflect.KType
import tech.ostack.kform.TypeInfo
import tech.ostack.kform.Validation
import tech.ostack.kform.datatypes.File
import tech.ostack.kform.datatypes.emptyPlaceholderFile
import tech.ostack.kform.schemas.util.acceptedFileTypesRestrictions
import tech.ostack.kform.schemas.util.commonRestrictions
import tech.ostack.kform.schemas.util.sizeBoundsRestrictions

/** Schema representing values of type [File]. */
public open class FileSchema(
    validations: Iterable<Validation<File>> = emptyList(),
    override val initialValue: File = emptyPlaceholderFile(),
) : AbstractSimpleSchema<File>(validations) {
    public constructor(
        vararg validations: Validation<File>,
        initialValue: File = emptyPlaceholderFile(),
    ) : this(validations.asIterable(), initialValue)

    override val typeInfo: TypeInfo =
        TypeInfo(
            File::class,
            restrictions =
                commonRestrictions(validations) +
                    sizeBoundsRestrictions(validations) +
                    acceptedFileTypesRestrictions(validations),
        )

    override fun assignableTo(type: KType): Boolean =
        (type.classifier as? KClass<*>)?.isInstance(emptyPlaceholderFile()) == true
}
