package tech.ostack.kform.schemas

import tech.ostack.kform.TypeInfo
import tech.ostack.kform.Validation
import tech.ostack.kform.schemas.util.commonRestrictions

/** Function responsible for creating a clone of a value of this schema. */
public typealias CloneFunction<T> = (value: T?) -> T?

/**
 * "Catch-all" schema representing (possibly nullable) values of any given type.
 *
 * @property clone Function used to create a clone of a value of this schema.
 */
public open class AnySchema<T>(
    validations: Iterable<Validation<T?>> = emptyList(),
    override val initialValue: T? = null,
    public val clone: CloneFunction<T>? = null,
) : AbstractSimpleSchema<T?>(validations) {
    public constructor(
        vararg validations: Validation<T?>,
        initialValue: T? = null,
        clone: CloneFunction<T>? = null,
    ) : this(validations.asIterable(), initialValue, clone)

    override val typeInfo: TypeInfo =
        TypeInfo(Any::class, nullable = true, restrictions = commonRestrictions(validations))

    override suspend fun clone(value: T?): T? = clone?.invoke(value) ?: value
}
