package tech.ostack.kform.internal.actions

import tech.ostack.kform.AbsolutePath
import tech.ostack.kform.FormManager
import tech.ostack.kform.ValueInfoHandler

/**
 * Action that calls [infoHandler] with the value-info of values at [path] and holds a lock over
 * said info until [infoHandler] finishes.
 */
internal class ValueInfoAction<T>(
    formManager: FormManager,
    path: AbsolutePath,
    val infoHandler: ValueInfoHandler<T>,
) : ReadValueStateAction<T>(formManager, path) {
    override fun toString() = "ValueInfo($path)"

    override suspend fun runValueState() = infoHandler(valueInfo(path))
}
