package tech.ostack.kform.internal.actions

import tech.ostack.kform.AbsolutePath
import tech.ostack.kform.FormManager
import tech.ostack.kform.internal.AccessValidationDaemon
import tech.ostack.kform.internal.ActionAccessType
import tech.ostack.kform.internal.ValidationDaemon

/** Action that stops the validation daemon. */
internal class StopValidationDaemonAction(
    formManager: FormManager,
    private val validationDaemon: ValidationDaemon,
) : FormManagerAction<Unit>(formManager) {
    override fun toString() = "StopValidationDaemon"

    override val accesses = listOf(AccessValidationDaemon(ActionAccessType.Write))
    override val accessedPaths = listOf(AbsolutePath.MATCH_ALL)

    override suspend fun run() = validationDaemon.stop()
}
