package tech.ostack.kform.internal.actions

import tech.ostack.kform.*
import tech.ostack.kform.internal.AccessIsDirty
import tech.ostack.kform.internal.AccessValueStateTree
import tech.ostack.kform.internal.ActionAccessType
import tech.ostack.kform.internal.StateImpl

/** Action that sets all values whose path matches [path] as pristine, as well as their children. */
internal class SetPristineAction(formManager: FormManager, private val path: AbsolutePath) :
    ValueStateAction<Unit>(formManager) {
    override fun toString() = "SetPristine($path)"

    override val accesses =
        listOf(AccessValueStateTree(ActionAccessType.Read), AccessIsDirty(ActionAccessType.Write))
    override val accessedPaths = listOf(path + AbsolutePathFragment.RecursiveWildcard)

    override suspend fun runValueState() =
        stateInfo(path).forEach { info ->
            setPristine(info.path, info.schema, info.state as StateImpl?)
        }

    private suspend fun setPristine(path: AbsolutePath, schema: Schema<*>, state: StateImpl?) {
        if (state != null && state.isDirty) {
            state.isDirty = false
            formManager.eventsBus.emit(StateEvent.DirtyChange(false, path, schema))
            if (state is ParentState) {
                for (childInfo in state.childrenStates(path, AbsolutePathFragment.Wildcard)) {
                    if (childInfo.state != null) {
                        setPristine(childInfo.path, childInfo.schema, childInfo.state as StateImpl)
                    }
                }
            }
        }
    }
}
