package tech.ostack.kform.internal.actions

import tech.ostack.kform.FormManager

/**
 * Action that sets the external context with name [externalContextName] available to validations.
 */
internal class SetExternalContextAction<T>(
    formManager: FormManager,
    override val externalContextName: String,
    private val externalContext: Any?,
) : WriteExternalContextAction<T?>(formManager) {
    override fun toString() = "SetExternalContext($externalContextName, $externalContext)"

    override suspend fun run(): T? {
        val hadExternalContext = externalContextName in formManager.externalContexts
        @Suppress("UNCHECKED_CAST")
        val oldExternalContext =
            formManager.externalContexts.put(externalContextName, externalContext) as T?

        if (!hadExternalContext || oldExternalContext != externalContext) {
            updateDependents()
        }

        return oldExternalContext
    }
}
