package tech.ostack.kform.internal.actions

import tech.ostack.kform.*
import tech.ostack.kform.internal.Action
import tech.ostack.kform.internal.removeFromParent

/**
 * Action that removes the values matching [fragment] from the collections that match [parentPath].
 */
internal class RemoveAction(
    formManager: FormManager,
    val parentPath: AbsolutePath,
    parentSchema: CollectionSchema<Any?, Any?>,
    val fragment: AbsolutePathFragment,
) : WriteValueStateAction<Unit>(formManager) {
    override fun toString() = "Remove($path)"

    override val accessedPaths =
        listOf(
            (if (parentSchema.supportsConcurrentRemoves) path else parentPath) +
                AbsolutePathFragment.RecursiveWildcard
        )

    val path
        get() = parentPath + fragment

    override fun overridesConflictingAction(action: Action<*>): Boolean =
        (action is SetAction &&
            (path + AbsolutePathFragment.RecursiveWildcard).contains(action.path)) ||
            (action is RemoveAction &&
                (path + AbsolutePathFragment.RecursiveWildcard).contains(action.parentPath))

    override suspend fun runWriteValueState() {
        valueInfo(parentPath).collect { parentInfo ->
            withSchemaEventsBus { eventsBus -> removeFromParent(parentInfo, fragment, eventsBus) }
        }
    }
}
