package tech.ostack.kform.internal.actions

import kotlinx.coroutines.flow.firstOrNull
import tech.ostack.kform.AbsolutePath
import tech.ostack.kform.FormManager

/** Action that returns whether a value exists matching [path]. */
internal class HasAction(formManager: FormManager, path: AbsolutePath) :
    ReadValueStateAction<Boolean>(formManager, path) {
    override fun toString() = "Has($path)"

    override suspend fun runValueState() = valueInfo(path).firstOrNull() != null
}
