package tech.ostack.kform.internal.actions

import kotlinx.coroutines.flow.single
import tech.ostack.kform.AbsolutePath
import tech.ostack.kform.FormManager
import tech.ostack.kform.ValueInfo

/** Action that returns a clone of the single value matching [path]. */
internal class GetCloneAction<T>(formManager: FormManager, path: AbsolutePath) :
    ReadValueStateAction<T>(formManager, path) {
    override fun toString() = "GetClone($path)"

    override suspend fun runValueState(): T {
        @Suppress("UNCHECKED_CAST") val info = valueInfo(path).single() as ValueInfo<T>
        return info.schema.clone(info.value)
    }
}
