package tech.ostack.kform.internal.actions

import kotlinx.coroutines.flow.single
import tech.ostack.kform.AbsolutePath
import tech.ostack.kform.FormManager
import tech.ostack.kform.ValueHandler

/**
 * Action that calls [valueHandler] with the single value matching [path] and holds a lock over said
 * value until [valueHandler] finishes.
 */
internal class GetAction<T, TResult>(
    formManager: FormManager,
    path: AbsolutePath,
    val valueHandler: ValueHandler<T, TResult>,
) : ReadValueStateAction<TResult>(formManager, path) {
    override fun toString() = "Get($path)"

    @Suppress("UNCHECKED_CAST")
    override suspend fun runValueState() = valueHandler(valueInfo(path).single().value as T)
}
