package tech.ostack.kform.internal.actions

import kotlinx.coroutines.CompletableDeferred
import tech.ostack.kform.FormManager
import tech.ostack.kform.internal.Action

/** Base action implementation with result, default priority, and utility methods. */
internal abstract class FormManagerAction<T>(val formManager: FormManager) : Action<T> {
    override val result = CompletableDeferred<T>(formManager.supervisorJob)
}
