package tech.ostack.kform.internal

import tech.ostack.kform.*

/** Sets value [toSet] at [fragment] on parent with info [parentInfo]. */
internal suspend fun setOnParent(
    parentInfo: ValueInfo<*>,
    fragment: AbsolutePathFragment,
    toSet: Any?,
    eventsBus: SchemaEventsBus,
) {
    val (parentValue, parentSchema, parentPath, parentSchemaPath) = parentInfo

    @Suppress("UNCHECKED_CAST") (parentSchema as ParentSchema<Any?>)
    // Always support setting all children via a wildcard
    if (
        fragment !is AbsolutePathFragment.Wildcard &&
            !parentSchema.isValidSetFragment(parentValue, fragment)
    ) {
        throw AtPathException(parentPath, "Cannot set child fragment: '$fragment'.")
    }
    // Disallow resetting a value that doesn't exist
    if (fragment is AbsolutePathFragment.CollectionEnd && toSet === INITIAL_VALUE) {
        throw AtPathException(parentPath, "Cannot reset child fragment: '$fragment'.")
    }
    // Set all children
    if (fragment is AbsolutePathFragment.Wildcard) {
        parentSchema.children(parentPath, parentSchemaPath, parentValue, fragment).collect {
            (_, childSchema, childPath) ->
            val valueToSet = if (toSet === INITIAL_VALUE) childSchema.initialValue else toSet
            parentSchema.set(
                parentPath,
                parentValue,
                childPath.lastFragment!!,
                valueToSet,
                eventsBus,
            )
        }
    }
    // Set single child
    else {
        val valueToSet =
            if (toSet === INITIAL_VALUE)
                parentSchema
                    .childrenSchemas(parentSchemaPath, parentPath, fragment)
                    .single()
                    .schema
                    .initialValue
            else toSet
        parentSchema.set(parentPath, parentValue, fragment, valueToSet, eventsBus)
    }
}

/** Removes values at [fragment] from parent with info [parentInfo]. */
internal suspend fun removeFromParent(
    parentInfo: ValueInfo<*>,
    fragment: AbsolutePathFragment,
    eventsBus: SchemaEventsBus,
) {
    val (parentValue, parentSchema, parentPath) = parentInfo

    @Suppress("UNCHECKED_CAST") (parentSchema as CollectionSchema<Any?, Any?>)
    // Always support removing all children via a wildcard
    if (
        fragment !is AbsolutePathFragment.Wildcard &&
            !parentSchema.isValidRemoveFragment(parentValue, fragment)
    ) {
        throw AtPathException(parentPath, "Cannot remove child fragment: '$fragment'.")
    }
    parentSchema.remove(parentPath, parentValue, fragment, eventsBus)
}
