package tech.ostack.kform.internal

import tech.ostack.kform.AbsolutePath
import tech.ostack.kform.AbsolutePathFragment
import tech.ostack.kform.Path

/** Path with its last fragment dropped if it was a recursive wildcard. */
internal fun Path.withoutDescendants(): Path =
    if (fragments.last() is AbsolutePathFragment.RecursiveWildcard) parent() else this

/** Absolute path with its last fragment dropped if it was a recursive wildcard. */
internal fun AbsolutePath.withoutDescendants(): AbsolutePath =
    if (lastFragment is AbsolutePathFragment.RecursiveWildcard) parent() else this
