package tech.ostack.kform.internal

import kotlinx.coroutines.CancellationException

/**
 * Exception thrown when an action is cancelled because it became redundant thanks to a new action
 * [newAction].
 */
internal class OverriddenActionException(val newAction: Action<*>) :
    CancellationException("Action cancelled due to: '$newAction'.")
