// package tech.ostack.kform.internal
//
// import tech.ostack.kform.*
// import tech.ostack.kform.collections.mutablePathMultimapOf
// import tech.ostack.kform.collections.set
// import tech.ostack.kform.internal.actions.ValidateAction
// import tech.ostack.kform.schemas.ComputedSchema
// import kotlinx.coroutines.*
// import kotlinx.coroutines.channels.Channel
// import kotlinx.coroutines.flow.MutableStateFlow
// import kotlinx.coroutines.flow.StateFlow
// import kotlinx.coroutines.flow.collect
//
// /** Messages used by the computed value daemon. */
// private sealed class ComputedValueDaemonMsg {
//     data object ComputeNext : ComputedValueDaemonMsg()
//
//     data object RetryCompute : ComputedValueDaemonMsg()
//
//     data class HandleValueEvent(val event: ValueEvent<*>) : ComputedValueDaemonMsg()
// }
//
// /** Daemon responsible for validating the form manager in the background. */
// internal class ComputedValueDaemon(private val formManager: FormManager) {
//     // Information on computed value dependencies:
//     internal val computedValueDependencies: ComputedValueDependencies =
//         buildComputedValueDependencies(formManager.formSchema).also {
//             FormManager.logger.debug { "Computed value dependencies: $it" }
//         }
//     internal val computedValueObservedDependencies: ObservedComputedValueDependencies =
//         buildObservedComputedValueDependencies(formManager.formSchema).also {
//             FormManager.logger.debug { "Observed computed value dependencies: $it" }
//         }
//     internal val externalContextComputedValueDependencies:
//         ExternalContextComputedValueDependencies =
//         buildExternalContextComputedValueDependencies(formManager.formSchema).also {
//             FormManager.logger.debug { "External context computed value dependencies: $it" }
//         }
//
//     // Computed value daemon status
//     private val _status = MutableStateFlow(ComputedValueStatus.Inactive)
//     val status: StateFlow<ComputedValueStatus> = _status
//
//     // Assignment to these variables is synchronised by the action manager (start/stop)
//     private var channel: Channel<ComputedValueDaemonMsg>? = null
//     private var messagesHandlerJob: Job? = null
//     private var unsubscribeEventsHandler: Unsubscribe? = null
//
//     // Access to these variables is synchronised by [channel] and [messagesHandlerJob]
//     private var computeAction: Action<Unit>? = null
//     private val uncomputedPaths = mutablePathMultimapOf<Unit>()
//     private var computing = false
//     private var computingPath: AbsolutePath? = null
//
//     private val statefulComputedValueStates = hashMapOf<AbsolutePath, Any?>()
//
//     /** Starts the validation daemon. */
//     suspend fun start() {
//         if (status.value != ComputedValueStatus.Inactive) {
//             return
//         }
//
//         val newChannel = Channel<ComputedValueDaemonMsg>(Channel.BUFFERED)
//         channel = newChannel
//         messagesHandlerJob =
//             formManager.scope.launch(CoroutineName("Computed value daemon messages handler")) {
//                 for (msg in newChannel) {
//                     when (msg) {
//                         is ComputedValueDaemonMsg.ComputeNext -> computeNext()
//                         is ComputedValueDaemonMsg.RetryCompute -> retryCompute()
//                         is ComputedValueDaemonMsg.HandleValueEvent -> handleValueEvent(msg.event)
//                     }
//                 }
//             }
//
//         unsubscribeEventsHandler =
//             formManager.subscribe(
//                 onSubscription = {
//                     for (schemaInfo in formManager.schemaInfo(AbsolutePath.MATCH_ALL)) {
//                         if (schemaInfo.schema is ComputedSchema) {
//                             addUncomputedPath(schemaInfo.queriedPath, false)
//                         }
//                     }
//                 }
//             ) { event ->
//                 when (event) {
//                     is ValueEvent.Init<*> ->
//                         formManager.scope.launch {
//                             newChannel.send(ValidationDaemonMsg.HandleInitEvent(event))
//                         }
//                     is ValueEvent.Destroy<*> ->
//                         formManager.scope.launch { ValidationDaemonMsg.HandleDestroyEvent(event)
// }
//                     is StateEvent.ValidationChange<*> ->
//                         formManager.scope.launch {
//
// newChannel.send(ValidationDaemonMsg.HandleValidationChangeEvent(event))
//                         }
//                     else -> {} // Other events are irrelevant
//                 }
//             }
//     }
//
//     /** Stops the validation daemon. */
//     suspend fun stop() {
//         if (status.value == AutoComputedValueStatus.Inactive) {
//             return
//         }
//
//         // Cancel runnings jobs and channel
//         channel!!.cancel()
//         computeAction?.cancel()
//         messagesHandlerJob!!.cancelAndJoin()
//         unsubscribeEventsHandler!!()
//
//         channel = null
//         messagesHandlerJob = null
//         unsubscribeEventsHandler = null
//
//         computeAction = null
//         uncomputedPaths.clear()
//         computing = false
//         computingPath = null
//
//         _status.emit(AutoComputedValueStatus.Inactive)
//         FormManager.logger.debug {
//             "Computed value daemon status changed to: ${AutoComputedValueStatus.Inactive}"
//         }
//     }
//
//     /**
//      * Validates the next unvalidated path if there is one. The path being validated is set as
//      * [computingPath].
//      *
//      * This is the only function that sets [computing] to `false` when there is nothing left to
//      * validate.
//      */
//     private suspend fun computeNext() {
//         if (!uncomputedPaths.isEmpty()) {
//             val (path, _, id) = uncomputedPaths.entries.first()
//             FormManager.logger.trace { "Computed value daemon: computing next ($path)" }
//             uncomputedPaths.removeEntry(id)
//             computingPath = path
//             compute(path)
//         } else {
//             _status.emit(AutoComputedValueStatus.ActiveIdle)
//             computing = false
//             FormManager.logger.debug {
//                 "Computed value daemon status changed to: ${AutoComputedValueStatus.ActiveIdle}"
//             }
//         }
//     }
//
//     /**
//      * Retries validating the [computingPath].
//      *
//      * If no [computingPath] exists, it means that it was destroyed (and handled by
//      * [handleDestroyEvent]) so we validate the next unvalidated path instead.
//      */
//     private suspend fun retryCompute() {
//         if (computingPath != null) {
//             FormManager.logger.trace {
//                 "Computed value daemon: retrying computation ($computingPath)"
//             }
//             uncomputedPaths.remove(computingPath!!)
//             compute(computingPath!!)
//         } else {
//             computeNext()
//         }
//     }
//
//     /**
//      * Validates [path].
//      *
//      * In case of success, schedules the validation of the next unvalidated path. Otherwise, when
//      * the validation was cancelled, schedules a retry of the current validation.
//      */
//     private fun compute(path: AbsolutePath) {
//         val channel = channel!!
//         val action = ValidateAction(formManager, path, { issuesFlow -> issuesFlow.collect() }, 1)
//         computeAction = action
//         formManager.scope.launch(CoroutineName("Computed value daemon: validate '$path'")) {
//             try {
//                 // Schedule a validate action with low priority (so it gets cancelled by
// user-input)
//                 formManager.scheduleActionAndAwait(action)
//                 channel.send(ComputedValueDaemonMsg.ComputeNext)
//             } catch (_: CancellationException) {
//                 channel.send(ComputedValueDaemonMsg.RetryValidate)
//             }
//         }
//     }
//
//     private suspend fun handleValueEvent(event: ValueEvent<*>) {
//         when (event) {
//             is ValueEvent.Init -> handleInitEvent(event)
//             is ValueEvent.Destroy -> handleDestroyEvent(event)
//         }
//     }
//
//     private suspend fun handleInitEvent(event: ValueEvent.Init<*>) {
//         FormManager.logger.trace { "Computed value daemon: handling init event (${event.path})" }
//         if (event.path !in uncomputedPaths) {
//             addUncomputedPath(event.path)
//         }
//     }
//
//     private fun handleDestroyEvent(event: ValueEvent.Destroy<*>) {
//         FormManager.logger.trace { "Computed value daemon: handling destroy event
// (${event.path})" }
//         removeUncomputedPath(event.path + AbsolutePathFragment.RecursiveWildcard)
//     }
//
//     private suspend fun addUncomputedPath(path: AbsolutePath, bundlePerSchema: Boolean = true) {
//         val wasEmpty = uncomputedPaths.isEmpty()
//         uncomputedPaths[path] = Unit
//
//         if (!computing && wasEmpty) {
//             computing = true
//             _status.emit(AutoComputedValueStatus.ActiveRunning)
//             FormManager.logger.debug {
//                 "Computed value daemon status changed to:
// ${AutoComputedValueStatus.ActiveRunning}"
//             }
//             val channel = channel!!
//             formManager.scope.launch { channel.send(ComputedValueDaemonMsg.ComputeNext) }
//         }
//     }
//
//     private fun removeUncomputedPath(path: AbsolutePath) {
//         uncomputedPaths.remove(path)
//
//         if (computing && computingPath != null && computingPath!! in path) {
//             computingPath = null
//         }
//     }
// }
