package tech.ostack.kform.internal

/** Access to the value/state tree. */
internal class AccessValueStateTree(override val accessType: ActionAccessType) : ActionAccess {
    override fun conflictsWith(access: ActionAccess) = access is AccessValueStateTree
}

/** Accesses the validation state of a value and allows access to its cached issues. */
internal class AccessValidationState(override val accessType: ActionAccessType) : ActionAccess {
    override fun conflictsWith(access: ActionAccess) = access is AccessValidationState
}

/** Access the validation deferred states within the state of a value. */
internal class AccessStatefulValidationDeferredState(override val accessType: ActionAccessType) :
    ActionAccess {
    override fun conflictsWith(access: ActionAccess) =
        access is AccessStatefulValidationDeferredState
}

/** Access computed value deferred state. */
internal class AccessStatefulComputedValueDeferredState(override val accessType: ActionAccessType) :
    ActionAccess {
    override fun conflictsWith(access: ActionAccess) =
        access is AccessStatefulComputedValueDeferredState
}

/** Access the dirty status within the state of a value. */
internal class AccessIsDirty(override val accessType: ActionAccessType) : ActionAccess {
    override fun conflictsWith(access: ActionAccess) = access is AccessIsDirty
}

/** Access the touched status within the state of a value. */
internal class AccessIsTouched(override val accessType: ActionAccessType) : ActionAccess {
    override fun conflictsWith(access: ActionAccess) = access is AccessIsTouched
}

/** Access the number of descendants displaying issues (both errors and warnings). */
internal class AccessDescendantsDisplayingIssues(override val accessType: ActionAccessType) :
    ActionAccess {
    override fun conflictsWith(access: ActionAccess) = access is AccessDescendantsDisplayingIssues
}

/** Access the external context. */
internal class AccessExternalContext(override val accessType: ActionAccessType) : ActionAccess {
    override fun conflictsWith(access: ActionAccess): Boolean = access is AccessExternalContext
}

/** Access the validation daemon. */
internal class AccessValidationDaemon(override val accessType: ActionAccessType) : ActionAccess {
    override fun conflictsWith(access: ActionAccess): Boolean = access is AccessValidationDaemon
}
