@file:JvmName("BigDecimals")

package tech.ostack.kform.datatypes

import kotlin.jvm.JvmName
import kotlinx.serialization.KSerializer
import kotlinx.serialization.Serializable
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import org.gciatto.kt.math.BigDecimal as BigDecimalKtMath

/** [BigDecimal][BigDecimalKtMath] as provided by `kt-math`, but with a serializer applied. */
public typealias BigDecimal = @Serializable(with = BigDecimalSerializer::class) BigDecimalKtMath

/** Serializer for [BigDecimal][BigDecimalKtMath]. */
public class BigDecimalSerializer : KSerializer<BigDecimalKtMath> {
    override val descriptor: SerialDescriptor =
        PrimitiveSerialDescriptor("org.gciatto.kt.math.BigDecimal", PrimitiveKind.STRING)

    override fun serialize(encoder: Encoder, value: BigDecimalKtMath): Unit =
        encoder.encodeString(value.toString())

    override fun deserialize(decoder: Decoder): BigDecimalKtMath =
        BigDecimalKtMath.of(decoder.decodeString())
}
