package tech.ostack.kform

import kotlin.js.JsName
import kotlin.reflect.KClass

/** Type of value represented by a schema. */
@JsName("TypeInfoKt")
public data class TypeInfo(
    /** Name of the type. */
    public val name: String,
    /** Whether the type is nullable. */
    public val nullable: Boolean = false,
    /** Type arguments. */
    public val arguments: List<TypeInfo> = emptyList(),
    /** Type and validation related "simple" restrictions, e.g. ("required", "min", "max", etc.). */
    public val restrictions: Map<String, Any?> = emptyMap(),
) {
    public constructor(
        kClass: KClass<*>?,
        nullable: Boolean = false,
        arguments: List<TypeInfo> = emptyList(),
        restrictions: Map<String, Any?> = emptyMap(),
    ) : this(kClass?.simpleName ?: ANONYMOUS_CLASS_NAME, nullable, arguments, restrictions)

    public override fun toString(): String = buildString {
        append(name)
        if (arguments.isNotEmpty()) {
            append(arguments.joinToString(separator = ", ", prefix = "<", postfix = ">"))
        }
        if (nullable) {
            append("?")
        }
    }

    public companion object {
        /** Name of type exposed when a class is anonymous. */
        public const val ANONYMOUS_CLASS_NAME: String = "anonymous"
    }
}
