package tech.ostack.kform

import kotlin.js.JsName

/** Fragment of a path. */
@JsName("PathFragmentKt")
public sealed class PathFragment {
    /** Path fragment representing the root path. */
    public data object Root : PathFragment()

    /** Path fragment representing the current path (`"."` in string notation). */
    public data object CurrentPath : PathFragment()

    /** Parent fragment representing the parent path (`".."` in string notation). */
    public data object ParentPath : PathFragment()
}

/** Fragment of an absolute path. */
@JsName("AbsolutePathFragmentKt")
public sealed class AbsolutePathFragment : PathFragment() {
    /**
     * Path fragment representing an identifier [id]. In string notation, the id fragment with [id]
     * `"x"` would be represented as `x`; if the string version of the fragment conflicts with a
     * different fragment, then the fragment is escaped, e.g. the id fragment with [id] `"*"` would
     * be represented as `~*` in string notation.
     */
    public data class Id(val id: String) : AbsolutePathFragment() {
        /**
         * Creates a new [Id] path fragment with [id] transformed into a string via `id.toString()`.
         */
        public constructor(id: Any) : this(id.toString())
    }

    /**
     * Path fragment representing the "end" of a collection (`"-"` in string notation).
     *
     * This fragment represents the fictional element after the last element of a collection.
     */
    public data object CollectionEnd : AbsolutePathFragment()

    /**
     * Wildcard fragment (`"*"` in string notation).
     *
     * Wildcard fragments match against any other fragments.
     */
    public data object Wildcard : AbsolutePathFragment()

    /**
     * Recursive wildcard fragment (`"**"` in string notation).
     *
     * Recursive wildcard fragments match against zero or more any other fragments.
     */
    public data object RecursiveWildcard : AbsolutePathFragment()
}
