package tech.ostack.kform.schemas

import kotlin.reflect.KClass
import kotlin.reflect.KType
import tech.ostack.kform.TypeInfo
import tech.ostack.kform.Validation
import tech.ostack.kform.schemas.util.commonRestrictions
import tech.ostack.kform.schemas.util.comparableBoundsRestrictions

/** Schema representing numeric values of type [Short]. */
public open class ShortSchema(
    validations: Iterable<Validation<Short>> = emptyList(),
    override val initialValue: Short = 0,
) : AbstractSimpleSchema<Short>(validations) {
    public constructor(
        vararg validations: Validation<Short>,
        initialValue: Short = 0,
    ) : this(validations.asIterable(), initialValue)

    override val typeInfo: TypeInfo =
        TypeInfo(
            Short::class,
            restrictions =
                commonRestrictions(validations) +
                    comparableBoundsRestrictions(validations, Short.MIN_VALUE, Short.MAX_VALUE),
        )

    override fun assignableTo(type: KType): Boolean =
        (type.classifier as? KClass<*>)?.isInstance(0.toShort()) == true

    override suspend fun fromAny(value: Any?): Short =
        when (value) {
            is Number -> value.toShort()
            is String -> value.toShort()
            else -> throw IllegalArgumentException("Cannot convert value '$value' to Short.")
        }
}
