package tech.ostack.kform.schemas

import kotlin.reflect.KClass
import kotlin.reflect.KType
import tech.ostack.kform.TypeInfo
import tech.ostack.kform.Validation
import tech.ostack.kform.schemas.util.commonRestrictions
import tech.ostack.kform.schemas.util.comparableBoundsRestrictions

/** Schema representing numeric values of type [Double]. */
public open class DoubleSchema(
    validations: Iterable<Validation<Double>> = emptyList(),
    override val initialValue: Double = 0.0,
) : AbstractSimpleSchema<Double>(validations) {
    public constructor(
        vararg validations: Validation<Double>,
        initialValue: Double = 0.0,
    ) : this(validations.asIterable(), initialValue)

    override val typeInfo: TypeInfo =
        TypeInfo(
            Double::class,
            restrictions =
                commonRestrictions(validations) + comparableBoundsRestrictions(validations),
        )

    override fun assignableTo(type: KType): Boolean =
        (type.classifier as? KClass<*>)?.isInstance(0.0) == true

    override suspend fun fromAny(value: Any?): Double =
        when (value) {
            is Number -> value.toDouble()
            is String -> value.toDouble()
            else -> throw IllegalArgumentException("Cannot convert value '$value' to Double.")
        }
}
