package tech.ostack.kform.schemas

import kotlin.reflect.KClass
import kotlin.reflect.KType
import tech.ostack.kform.TypeInfo
import tech.ostack.kform.Validation
import tech.ostack.kform.schemas.util.commonRestrictions
import tech.ostack.kform.schemas.util.comparableBoundsRestrictions

/** Schema representing values of type [Char]. */
public open class CharSchema(
    validations: Iterable<Validation<Char>> = emptyList(),
    override val initialValue: Char = 0.toChar(),
) : AbstractSimpleSchema<Char>(validations) {
    public constructor(
        vararg validations: Validation<Char>,
        initialValue: Char = 0.toChar(),
    ) : this(validations.asIterable(), initialValue)

    override val typeInfo: TypeInfo =
        TypeInfo(
            Char::class,
            restrictions =
                commonRestrictions(validations) +
                    comparableBoundsRestrictions(validations, Char.MIN_VALUE, Char.MAX_VALUE),
        )

    override fun assignableTo(type: KType): Boolean =
        (type.classifier as? KClass<*>)?.isInstance(0.toChar()) == true

    override suspend fun fromAny(value: Any?): Char =
        when (value) {
            is Char -> value
            is Number -> value.toInt().toChar()
            is String -> value.single()
            else -> throw IllegalArgumentException("Cannot convert value '$value' to Char.")
        }
}
