package tech.ostack.kform.schemas

import kotlin.reflect.KClass
import kotlin.reflect.KType
import tech.ostack.kform.TypeInfo
import tech.ostack.kform.Validation
import tech.ostack.kform.schemas.util.commonRestrictions
import tech.ostack.kform.schemas.util.comparableBoundsRestrictions

/** Schema representing numeric values of type [Byte]. */
public open class ByteSchema(
    validations: Iterable<Validation<Byte>> = emptyList(),
    override val initialValue: Byte = 0,
) : AbstractSimpleSchema<Byte>(validations) {
    public constructor(
        vararg validations: Validation<Byte>,
        initialValue: Byte = 0,
    ) : this(validations.asIterable(), initialValue)

    override val typeInfo: TypeInfo =
        TypeInfo(
            Byte::class,
            restrictions =
                commonRestrictions(validations) +
                    comparableBoundsRestrictions(validations, Byte.MIN_VALUE, Byte.MAX_VALUE),
        )

    override fun assignableTo(type: KType): Boolean =
        (type.classifier as? KClass<*>)?.isInstance(0.toByte()) == true

    override suspend fun fromAny(value: Any?): Byte =
        when (value) {
            is Number -> value.toByte()
            is String -> value.toByte()
            else -> throw IllegalArgumentException("Cannot convert value '$value' to Byte.")
        }
}
