package tech.ostack.kform.schemas

import kotlin.reflect.KClass
import kotlin.reflect.KType
import tech.ostack.kform.TypeInfo
import tech.ostack.kform.Validation
import tech.ostack.kform.schemas.util.commonRestrictions

/** Schema representing values of type [Boolean]. */
public open class BooleanSchema(
    validations: Iterable<Validation<Boolean>> = emptyList(),
    override val initialValue: Boolean = false,
) : AbstractSimpleSchema<Boolean>(validations) {
    public constructor(
        vararg validations: Validation<Boolean>,
        initialValue: Boolean = false,
    ) : this(validations.asIterable(), initialValue)

    override val typeInfo: TypeInfo =
        TypeInfo(Boolean::class, restrictions = commonRestrictions(validations))

    override fun assignableTo(type: KType): Boolean =
        (type.classifier as? KClass<*>)?.isInstance(false) == true

    override suspend fun fromAny(value: Any?): Boolean =
        when (value) {
            is Boolean -> value
            is String -> value.toBoolean()
            else -> throw IllegalArgumentException("Cannot convert value '$value' to Boolean.")
        }
}
