package tech.ostack.kform.schemas

import tech.ostack.kform.*

/**
 * Abstract schema representing collections of type [T] with elements of type [TChildren] whose
 * schema is of type [TSchema].
 *
 * @property elementsSchema Schema of the collection's elements.
 */
public abstract class AbstractCollectionSchema<T, TChildren, TSchema : Schema<TChildren>>(
    public val elementsSchema: TSchema
) : CollectionSchema<T, TChildren> {
    override fun childrenSchemas(
        path: AbsolutePath,
        queriedPath: AbsolutePath,
        fragment: AbsolutePathFragment,
    ): Sequence<SchemaInfo<TChildren>> = sequence {
        yield(
            SchemaInfo(
                elementsSchema,
                path.append(AbsolutePathFragment.Wildcard),
                queriedPath.append(fragment),
            )
        )
    }
}
