package tech.ostack.kform.internal.actions

import tech.ostack.kform.AbsolutePath
import tech.ostack.kform.FormManager
import tech.ostack.kform.StateEvent
import tech.ostack.kform.StateInfo
import tech.ostack.kform.internal.AccessIsDirty
import tech.ostack.kform.internal.AccessValueStateTree
import tech.ostack.kform.internal.ActionAccessType
import tech.ostack.kform.internal.StateImpl

/** Action that sets all values whose path matches [path] as dirty, as well as their parents. */
internal class SetDirtyAction(formManager: FormManager, private val path: AbsolutePath) :
    ValueStateAction<Unit>(formManager) {
    override fun toString() = "SetDirty($path)"

    override val accesses =
        listOf(AccessValueStateTree(ActionAccessType.Read), AccessIsDirty(ActionAccessType.Write))
    override val accessedPaths = parentPaths(path) + path

    override suspend fun runValueState() = stateInfo(path).forEach { info -> setDirty(info) }

    private tailrec suspend fun setDirty(info: StateInfo<*>) {
        val (state, schema, path) = info
        state as StateImpl?
        if (state != null && !state.isDirty) {
            state.isDirty = true
            formManager.eventsBus.emit(StateEvent.DirtyChange(true, path, schema))
            if (info.path != AbsolutePath.ROOT) {
                setDirty(stateInfo(info.path.parent()).single())
            }
        }
    }
}
