package tech.ostack.kform.internal.actions

import tech.ostack.kform.FormManager

/**
 * Action that removes the external context with name [externalContextName] available to
 * validations.
 */
internal class RemoveExternalContextAction<T>(
    formManager: FormManager,
    override val externalContextName: String,
) : WriteExternalContextAction<T?>(formManager) {
    override fun toString() = "RemoveExternalContext($externalContextName)"

    override suspend fun run(): T? {
        val hadExternalContext = externalContextName in formManager.externalContexts
        var removedExternalContext: T? = null

        if (hadExternalContext) {
            @Suppress("UNCHECKED_CAST")
            removedExternalContext = formManager.externalContexts.remove(externalContextName) as T?
            updateDependents()
        }

        return removedExternalContext
    }
}
