package tech.ostack.kform.internal.actions

import tech.ostack.kform.AbsolutePath
import tech.ostack.kform.AbsolutePathFragment
import tech.ostack.kform.FormManager
import tech.ostack.kform.internal.AccessValueStateTree
import tech.ostack.kform.internal.ActionAccess
import tech.ostack.kform.internal.ActionAccessType

/** Action reading values and/or their state. */
internal abstract class ReadValueStateAction<T>(formManager: FormManager, val path: AbsolutePath) :
    ValueStateAction<T>(formManager) {
    override val accesses: List<ActionAccess> =
        mutableListOf(AccessValueStateTree(ActionAccessType.Read))

    override val accessedPaths: List<AbsolutePath> =
        mutableListOf(path + AbsolutePathFragment.RecursiveWildcard)
}
