package tech.ostack.kform.internal.actions

import tech.ostack.kform.AbsolutePath
import tech.ostack.kform.AbsolutePathFragment
import tech.ostack.kform.FormManager
import tech.ostack.kform.internal.AccessIsTouched
import tech.ostack.kform.internal.AccessValueStateTree
import tech.ostack.kform.internal.ActionAccessType
import tech.ostack.kform.internal.StateImpl

/** Action that returns whether at least one value matching [path] has been touched. */
internal class IsTouchedAction(formManager: FormManager, private val path: AbsolutePath) :
    ValueStateAction<Boolean>(formManager) {
    override fun toString() = "IsTouched($path)"

    override val accesses =
        listOf(AccessValueStateTree(ActionAccessType.Read), AccessIsTouched(ActionAccessType.Read))
    override val accessedPaths = listOf(path + AbsolutePathFragment.RecursiveWildcard)

    override suspend fun runValueState(): Boolean =
        stateInfo(path).any { info -> (info.state as StateImpl).isTouched }
}
