package tech.ostack.kform.internal.actions

import tech.ostack.kform.AbsolutePath
import tech.ostack.kform.AbsolutePathFragment
import tech.ostack.kform.FormManager
import tech.ostack.kform.internal.AccessIsDirty
import tech.ostack.kform.internal.AccessValueStateTree
import tech.ostack.kform.internal.ActionAccessType
import tech.ostack.kform.internal.StateImpl

/** Action that returns whether at least one value matching [path] is dirty. */
internal class IsDirtyAction(formManager: FormManager, private val path: AbsolutePath) :
    ValueStateAction<Boolean>(formManager) {
    override fun toString() = "IsDirty($path)"

    override val accesses =
        listOf(AccessValueStateTree(ActionAccessType.Read), AccessIsDirty(ActionAccessType.Read))
    override val accessedPaths = listOf(path + AbsolutePathFragment.RecursiveWildcard)

    override suspend fun runValueState(): Boolean =
        stateInfo(path).any { info -> (info.state as StateImpl).isDirty }
}
