package tech.ostack.kform.internal.actions

import kotlinx.coroutines.flow.map
import tech.ostack.kform.*
import tech.ostack.kform.internal.*

/**
 * Action that calls [infoHandler] with all info of values at [path] and holds a lock over said info
 * until [infoHandler] finishes.
 */
internal class InfoAction<T>(
    formManager: FormManager,
    path: AbsolutePath,
    val infoHandler: InfoHandler<T>,
) : ReadValueStateAction<T>(formManager, path) {
    override fun toString() = "Info($path)"

    override val accesses =
        listOf(
            AccessValueStateTree(ActionAccessType.Read),
            AccessIsDirty(ActionAccessType.Read),
            AccessIsTouched(ActionAccessType.Read),
            AccessValidationState(ActionAccessType.Read),
            AccessDescendantsDisplayingIssues(ActionAccessType.Read),
        )

    override suspend fun runValueState() =
        infoHandler(
            valueStateInfo(path).map { info ->
                val state = info.state as StateImpl

                @Suppress("UNCHECKED_CAST")
                Info(
                    info.value,
                    info.schema as Schema<Any?>,
                    info.path,
                    info.schemaPath,
                    state.isDirty,
                    state.isTouched,
                    state.getAllVisibleIssues(),
                    state.validationStatus,
                    state.displayStatus(),
                )
            }
        )
}
