package tech.ostack.kform.internal.actions

import tech.ostack.kform.AbsolutePath
import tech.ostack.kform.ExternalContextHandler
import tech.ostack.kform.FormManager
import tech.ostack.kform.internal.AccessExternalContext
import tech.ostack.kform.internal.ActionAccessType

/**
 * Action that returns the external context with name [externalContextName] available to
 * validations.
 */
internal class GetExternalContextAction<TContext, T>(
    formManager: FormManager,
    private val externalContextName: String,
    private val externalContextHandler: ExternalContextHandler<TContext, T>,
) : FormManagerAction<T>(formManager) {
    override fun toString() = "GetExternalContext($externalContextName)"

    override val accesses = listOf(AccessExternalContext(ActionAccessType.Read))
    override val accessedPaths: List<AbsolutePath> = emptyList()

    override suspend fun run(): T =
        @Suppress("UNCHECKED_CAST")
        externalContextHandler(formManager.externalContexts[externalContextName] as TContext)
}
