package tech.ostack.kform.internal.actions

import tech.ostack.kform.FormManager
import tech.ostack.kform.LocatedValidationIssue
import tech.ostack.kform.internal.*

/** Action that adds external issues to the form manager. */
internal class AddExternalIssuesAction(
    formManager: FormManager,
    private val externalIssues: Iterable<LocatedValidationIssue>,
) : ValueStateAction<Unit>(formManager) {
    override fun toString() = "AddExternalIssues(${externalIssues.toList()})"

    override val accesses =
        listOf(
            AccessValueStateTree(ActionAccessType.Read),
            AccessValidationState(ActionAccessType.Write),
            AccessIsTouched(ActionAccessType.Read),
            AccessDescendantsDisplayingIssues(ActionAccessType.Read),
        )
    override val accessedPaths = externalIssues.mapTo(HashSet()) { it.path }

    override suspend fun runValueState() {
        for ((path, issues) in externalIssues.groupBy { it.path }) {
            val (state, schema) = stateInfo(path).single()
            state as StateImpl

            val oldLocalDisplayStatus = state.localDisplayStatus()
            val oldDisplayStatus = state.displayStatus()

            // Add external issues to state
            state.addExternalIssues(issues)
            formManager.externalIssuesDependencies.addDependenciesOfExternalIssues(issues)

            ValidateAction.updateValidationState(
                formManager,
                schema,
                path,
                state,
                oldLocalDisplayStatus,
                oldDisplayStatus,
                descendantsDisplayingIssuesToUpdate,
            )
        }
    }
}
