package tech.ostack.kform.internal

import tech.ostack.kform.SchemaEventsBus
import tech.ostack.kform.ValueEvent

/** Implementation of the schema events bus using a callback. */
internal class SchemaEventsCallbackBus(
    private val eventHandler: suspend (event: ValueEvent<*>) -> Unit
) : SchemaEventsBus {
    override suspend fun emit(event: ValueEvent<*>) = eventHandler(event)
}
