package tech.ostack.kform.internal

import kotlin.reflect.KClass
import kotlin.reflect.KType

/** Converts a KType [type] into a string, using the simple name for classes. */
internal fun kTypeToString(type: KType): String = buildString {
    append(
        if (type.classifier is KClass<*>) (type.classifier as KClass<*>).simpleName
        else type.toString()
    )
    if (type.arguments.isNotEmpty()) {
        append(
            type.arguments.joinToString(prefix = "<", postfix = ">") {
                if (it.type == null) "*" else kTypeToString(it.type!!)
            }
        )
    }
    if (type.isMarkedNullable) {
        append("?")
    }
}
