@file:JvmName("BigIntegers")

package tech.ostack.kform.datatypes

import kotlin.jvm.JvmName
import kotlinx.serialization.KSerializer
import kotlinx.serialization.Serializable
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import org.gciatto.kt.math.BigInteger as BigIntegerKtMath

/** [BigInteger][BigIntegerKtMath] as provided by `kt-math`, but with a serializer applied. */
public typealias BigInteger = @Serializable(with = BigIntegerSerializer::class) BigIntegerKtMath

/** Serializer for [BigInteger][BigIntegerKtMath]. */
public class BigIntegerSerializer : KSerializer<BigIntegerKtMath> {
    override val descriptor: SerialDescriptor =
        PrimitiveSerialDescriptor("org.gciatto.kt.math.BigInteger", PrimitiveKind.STRING)

    override fun serialize(encoder: Encoder, value: BigIntegerKtMath): Unit =
        encoder.encodeString(value.toString())

    override fun deserialize(decoder: Decoder): BigIntegerKtMath =
        BigIntegerKtMath.of(decoder.decodeString())
}
