package tech.ostack.kform

/**
 * State associated with each value in the form manager.
 *
 * The actual implementation is internal and not relevant to the outside world, however, it might be
 * interesting to know what is actually stored in the state: among others, the state contains the
 * `dirty`/`touched` status of each value as well as a cache of known validation issues associated
 * with the value.
 */
public interface State

/**
 * State for parent values (i.e. values represented by [parent schemas][ParentSchema]).
 *
 * Implementations of this interface are responsible for storing the states associated with the
 * children of a parent value.
 */
public interface ParentState : State {
    public fun childrenStates(
        path: AbsolutePath,
        fragment: AbsolutePathFragment,
    ): Sequence<StateInfo<*>>

    public fun setState(fragment: AbsolutePathFragment.Id, state: State?)
}

/**
 * State for collections (i.e. values represented by [collection schemas][CollectionSchema]).
 *
 * Implementations of this interface are responsible for storing the states associated with the
 * children of a collection.
 */
public interface CollectionState : ParentState {
    public fun hasState(fragment: AbsolutePathFragment.Id): Boolean

    public fun removeState(fragment: AbsolutePathFragment.Id)
}
