/*
 * Decompiled with CFR 0.152.
 */
package tech.ostack.kform.util;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.ostack.kform.AbsolutePath;
import tech.ostack.kform.AbsolutePathFragment;
import tech.ostack.kform.CollectionSchema;
import tech.ostack.kform.FormUtils;
import tech.ostack.kform.InvalidPathException;
import tech.ostack.kform.ParentSchema;
import tech.ostack.kform.Path;
import tech.ostack.kform.Paths;
import tech.ostack.kform.Schema;
import tech.ostack.kform.SchemaInfo;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"comparePaths", "", "Ltech/ostack/kform/Schema;", "path1", "Ltech/ostack/kform/Path;", "path2", "", "toPositiveIntWithoutLeadingZeroesOrNull", "(Ljava/lang/String;)Ljava/lang/Integer;", "kform"})
@JvmName(name="SchemaPathUtils")
@SourceDebugExtension(value={"SMAP\nSchemaPathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaPathUtils.kt\ntech/ostack/kform/util/SchemaPathUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,144:1\n209#2,8:145\n209#2,8:153\n*S KotlinDebug\n*F\n+ 1 SchemaPathUtils.kt\ntech/ostack/kform/util/SchemaPathUtils\n*L\n75#1:145,8\n82#1:153,8\n*E\n"})
public final class SchemaPathUtils {
    public static final int comparePaths(@NotNull Schema<?> $this$comparePaths, @NotNull Path path1, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter($this$comparePaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path1, (String)"path1");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        AbsolutePath absolutePath1 = Paths.toAbsolutePath(path1);
        AbsolutePath absolutePath2 = Paths.toAbsolutePath(path2);
        Schema<Object> curSchema = $this$comparePaths;
        int n = Math.min(absolutePath1.getSize(), absolutePath2.getSize());
        for (int i = 0; i < n; ++i) {
            AbsolutePathFragment.Id id2;
            AbsolutePathFragment.Id id1;
            Schema<Object> schema = absolutePath1.get(i);
            if ((schema instanceof AbsolutePathFragment.Id ? (AbsolutePathFragment.Id)((Object)schema) : null) == null) {
                throw new InvalidPathException(absolutePath1, "Compared paths must only contain ids.");
            }
            id1 = id1;
            AbsolutePathFragment absolutePathFragment = absolutePath2.get(i);
            if ((absolutePathFragment instanceof AbsolutePathFragment.Id ? (AbsolutePathFragment.Id)absolutePathFragment : null) == null) {
                throw new InvalidPathException(absolutePath2, "Compared paths must only contain ids.");
            }
            id2 = id2;
            schema = curSchema;
            if (schema instanceof CollectionSchema) {
                if (!Intrinsics.areEqual((Object)id1, (Object)id2)) {
                    Integer int1 = SchemaPathUtils.toPositiveIntWithoutLeadingZeroesOrNull(id1.getId());
                    Integer int2 = SchemaPathUtils.toPositiveIntWithoutLeadingZeroesOrNull(id2.getId());
                    return int1 != null && int2 != null ? Intrinsics.compare((int)int1, (int)int2) : id1.getId().compareTo(id2.getId());
                }
                curSchema = FormUtils.schema(curSchema, Path.CHILDREN);
                continue;
            }
            if (schema instanceof ParentSchema) {
                if (!Intrinsics.areEqual((Object)id1, (Object)id2)) {
                    int id2Index;
                    int id1Index;
                    block16: {
                        int n2;
                        Sequence<SchemaInfo<?>> childrenSchemasInfo;
                        block15: {
                            int n3;
                            Sequence<SchemaInfo<?>> $this$indexOfFirst$iv = childrenSchemasInfo = ((ParentSchema)curSchema).childrenSchemas(AbsolutePath.ROOT, AbsolutePath.ROOT, AbsolutePathFragment.Wildcard.INSTANCE);
                            boolean $i$f$indexOfFirst = false;
                            int index$iv = 0;
                            for (Object item$iv : $this$indexOfFirst$iv) {
                                if (index$iv < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                SchemaInfo it = (SchemaInfo)item$iv;
                                boolean bl = false;
                                if (Intrinsics.areEqual((Object)it.getPath().getLastFragment(), (Object)id1)) {
                                    n3 = index$iv;
                                    break block15;
                                }
                                ++index$iv;
                            }
                            n3 = id1Index = -1;
                        }
                        if (id1Index == -1) {
                            throw new InvalidPathException(new AbsolutePath(CollectionsKt.slice(absolutePath1.getFragments(), (IntRange)new IntRange(0, i))), "No schema matches this path.");
                        }
                        Sequence<SchemaInfo<?>> $this$indexOfFirst$iv = childrenSchemasInfo;
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$indexOfFirst$iv) {
                            if (index$iv < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            SchemaInfo it = (SchemaInfo)item$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getPath().getLastFragment(), (Object)id2)) {
                                n2 = index$iv;
                                break block16;
                            }
                            ++index$iv;
                        }
                        n2 = id2Index = -1;
                    }
                    if (id2Index == -1) {
                        throw new InvalidPathException(new AbsolutePath(CollectionsKt.slice(absolutePath1.getFragments(), (IntRange)new IntRange(0, i))), "No schema matches this path.");
                    }
                    return Intrinsics.compare((int)id1Index, (int)id2Index);
                }
                curSchema = ((SchemaInfo)SequencesKt.single(((ParentSchema)curSchema).childrenSchemas(AbsolutePath.ROOT, AbsolutePath.ROOT, id1))).getSchema();
                continue;
            }
            throw new InvalidPathException(new AbsolutePath(CollectionsKt.slice(absolutePath1.getFragments(), (IntRange)RangesKt.until((int)0, (int)i))), "Schema is not a parent schema.");
        }
        return Intrinsics.compare((int)absolutePath1.getSize(), (int)absolutePath2.getSize());
    }

    public static final int comparePaths(@NotNull Schema<?> $this$comparePaths, @NotNull String path1, @NotNull String path2) {
        Intrinsics.checkNotNullParameter($this$comparePaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path1, (String)"path1");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        return SchemaPathUtils.comparePaths($this$comparePaths, new AbsolutePath(path1), new AbsolutePath(path2));
    }

    private static final Integer toPositiveIntWithoutLeadingZeroesOrNull(String $this$toPositiveIntWithoutLeadingZeroesOrNull) {
        return StringsKt.startsWith$default((String)$this$toPositiveIntWithoutLeadingZeroesOrNull, (String)"-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$toPositiveIntWithoutLeadingZeroesOrNull, (String)"0", (boolean)false, (int)2, null) && $this$toPositiveIntWithoutLeadingZeroesOrNull.length() != 1 ? null : StringsKt.toIntOrNull((String)$this$toPositiveIntWithoutLeadingZeroesOrNull);
    }
}

