import tech.ostack.kform.validations.UniqueItems
import tech.ostack.kform.validations.UniqueItemsBy

/** [Unique items by][UniqueItemsBy] validation for use from JavaScript. */
@JsExport
@JsName("uniqueItemsBy")
public fun <T, TKey> uniqueItemsByJs(
    selector: (element: T) -> TKey?,
    emitAllRepetitions: Boolean = true,
    code: String = UniqueItemsBy.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Any> =
    UniqueItemsBy(emitAllRepetitions, code, severity.toValidationIssueSeverityKt(), selector)
        .cachedToJs()

/** [Unique items][UniqueItems] validation for use from JavaScript. */
@JsExport
@JsName("uniqueItems")
public fun <T> uniqueItemsJs(
    emitAllRepetitions: Boolean = true,
    treatNullAsUnique: Boolean = true,
    code: String = UniqueItems.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Any> =
    UniqueItems(emitAllRepetitions, treatNullAsUnique, code, severity.toValidationIssueSeverityKt())
        .cachedToJs()
