import tech.ostack.kform.validations.MaxSize
import tech.ostack.kform.validations.MinSize
import tech.ostack.kform.validations.Size

/** [Size] validation wrapper for use from JavaScript. */
@JsExport
@JsName("size")
public fun <T> sizeJs(
    requiredSize: Int,
    code: String = Size.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Array<T>> =
    Size(requiredSize, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Minimum size][MinSize] validation wrapper for use from JavaScript. */
@JsExport
@JsName("minSize")
public fun <T> minSizeJs(
    minSize: Int,
    code: String = MinSize.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Array<T>> =
    MinSize(minSize, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Maximum size][MaxSize] validation wrapper for use from JavaScript. */
@JsExport
@JsName("maxSize")
public fun <T> maxSizeJs(
    maxSize: Int,
    code: String = MaxSize.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<Array<T>> =
    MaxSize(maxSize, code, severity.toValidationIssueSeverityKt()).cachedToJs()
