import tech.ostack.kform.validations.Length
import tech.ostack.kform.validations.MaxLength
import tech.ostack.kform.validations.MinLength

/** [Length] validation wrapper for use from JavaScript. */
@JsExport
@JsName("length")
public fun lengthJs(
    requiredLength: Int,
    code: String = Length.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<String> =
    Length(requiredLength, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Minimum length][MinLength] validation wrapper for use from JavaScript. */
@JsExport
@JsName("minLength")
public fun minLengthJs(
    minLength: Int,
    code: String = MinLength.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<String> =
    MinLength(minLength, code, severity.toValidationIssueSeverityKt()).cachedToJs()

/** [Maximum length][MaxLength] validation wrapper for use from JavaScript. */
@JsExport
@JsName("maxLength")
public fun maxLengthJs(
    maxLength: Int,
    code: String = MaxLength.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<String> =
    MaxLength(maxLength, code, severity.toValidationIssueSeverityKt()).cachedToJs()
