import tech.ostack.kform.datatypes.File
import tech.ostack.kform.validations.Accepts

/** [Accepts] validation wrapper for use from JavaScript. */
@JsExport
@JsName("accepts")
@Suppress("NON_EXPORTABLE_TYPE")
public fun acceptsJs(
    allowedFileTypes: Array<String>,
    code: String = Accepts.DEFAULT_CODE,
    severity: ValidationIssueSeverityJs = "error",
): ValidationJs<File> =
    Accepts(allowedFileTypes.asIterable(), code, severity.toValidationIssueSeverityKt())
        .cachedToJs()
