@file:OptIn(DelicateCoroutinesApi::class)

import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.GlobalScope
import tech.ostack.kform.LocatedValidationIssue
import tech.ostack.kform.Schema
import tech.ostack.kform.util.convertTableRowIdsToIndices
import tech.ostack.kform.util.convertTableRowIndicesToIds

@JsExport
@Suppress("UNCHECKED_CAST")
public fun <T> convertPathTableRowIndicesToIds(
    path: Any,
    formSchema: Any,
    formValue: T,
): CancellablePromise<AbsolutePathJs> =
    GlobalScope.cancellablePromise {
        path
            .toPathKt()
            .convertTableRowIndicesToIds(formSchema.toSchemaKt() as Schema<T>, formValue)
            .cachedToJs()
    }

@JsExport
@Suppress("UNCHECKED_CAST")
public fun <T> convertPathTableRowIdsToIndices(
    path: Any,
    formSchema: Any,
    formValue: T,
): CancellablePromise<AbsolutePathJs> =
    GlobalScope.cancellablePromise {
        path
            .toPathKt()
            .convertTableRowIdsToIndices(formSchema.toSchemaKt() as Schema<T>, formValue)
            .cachedToJs()
    }

@JsExport
@Suppress("UNCHECKED_CAST")
public fun <T> convertIssueTableRowIndicesToIds(
    issue: Any,
    formSchema: Any,
    formValue: T,
): CancellablePromise<LocatedValidationIssueJs> =
    GlobalScope.cancellablePromise {
        issue
            .toLocatedValidationIssueKt()
            .convertTableRowIndicesToIds(formSchema.toSchemaKt() as Schema<T>, formValue)
            .cachedToJs()
    }

@JsExport
@Suppress("UNCHECKED_CAST")
public fun <T> convertIssuesTableRowIndicesToIds(
    issues: Any,
    formSchema: Any,
    formValue: T,
): CancellablePromise<Array<LocatedValidationIssueJs>> =
    GlobalScope.cancellablePromise {
        issues
            .toIterableKt<Any, LocatedValidationIssue> { it.toLocatedValidationIssueKt() }
            .convertTableRowIndicesToIds(formSchema.toSchemaKt() as Schema<T>, formValue)
            .map { it.cachedToJs() }
            .toTypedArray()
    }
