import tech.ostack.kform.schemas.ComputedSchema
import tech.ostack.kform.schemas.NullableSchema

@JsExport
public fun <T> nullableSchemaInnerSchema(schema: SchemaJs<T?>): SchemaJs<T> =
    if (schema.schemaKt is NullableSchema<T>) schema.schemaKt.innerSchema.cachedToJs()
    else error("Invalid argument: provided schema is not nullable.")

@JsExport
public fun isComputedSchema(schema: SchemaJs<Any?>): Boolean = schema.schemaKt is ComputedSchema

@JsExport
public fun <T> computedSchemaInnerSchema(schema: SchemaJs<T>): SchemaJs<T> =
    if (schema.schemaKt is ComputedSchema<T>) schema.schemaKt.innerSchema.cachedToJs()
    else error("Invalid argument: provided schema is not computed.")
