import tech.ostack.kform.datatypes.Table
import tech.ostack.kform.datatypes.tableOf
import tech.ostack.kform.schemas.TableSchema

/** Schema representing a table. */
@JsName("tableSchema")
@JsExport
@Suppress("NON_EXPORTABLE_TYPE")
public fun <T> tableSchemaJs(
    optionsOrElementsSchema: Any,
    elementsSchema: SchemaJs<T>? = null,
): SchemaJs<Table<T>> =
    @Suppress("UNCHECKED_CAST", "UNCHECKED_CAST_TO_EXTERNAL_INTERFACE")
    when (elementsSchema) {
        null -> TableSchema((optionsOrElementsSchema as SchemaJs<T>).schemaKt)
        else -> {
            val options = optionsOrElementsSchema as SchemaOptionsJs<Table<T>>
            TableSchema(
                elementsSchema.schemaKt,
                options.validations?.map { it.validationKt } ?: emptyList(),
                options.initialValue ?: tableOf(),
            )
        }
    }.cachedToJs()
