import tech.ostack.kform.datatypes.File
import tech.ostack.kform.datatypes.emptyPlaceholderFile
import tech.ostack.kform.schemas.FileSchema

/** [File schema][FileSchema] wrapper for use from JavaScript. */
@JsName("fileSchema")
@JsExport
@Suppress("NON_EXPORTABLE_TYPE")
public fun fileSchemaJs(options: SchemaOptionsJs<File>? = null): SchemaJs<File> =
    FileSchema(
            options?.validations?.map { it.validationKt } ?: emptyList(),
            options?.initialValue ?: emptyPlaceholderFile(),
        )
        .cachedToJs()
