import tech.ostack.kform.datatypes.BigInteger
import tech.ostack.kform.schemas.BigIntegerSchema

/**
 * Schema representing big integers. Wraps a [big integer schema][BigIntegerSchema] for use from
 * JavaScript.
 */
@JsName("bigIntegerSchema")
@JsExport
public fun bigIntegerSchemaJs(options: SchemaOptionsJs<BigInteger>? = null): SchemaJs<BigInteger> =
    (if (options?.initialValue != null)
            BigIntegerSchema(
                options.validations?.map { it.validationKt } ?: emptyList(),
                options.initialValue!!,
            )
        else BigIntegerSchema(options?.validations?.map { it.validationKt } ?: emptyList()))
        .cachedToJs()
