/** Converts an iterable into an array while caching the conversion. */
internal fun <T> Iterable<T>.cachedToJs(): Array<T> =
    getOrSetFromCache(this) { toList().toTypedArray() }

/** Converts an iterable into an array while caching the conversion and mapping each element. */
internal fun <T, TResult> Iterable<T>.cachedToJs(
    valueMapper: (value: T) -> TResult
): Array<TResult> = getOrSetFromCache(this) { map(valueMapper).toTypedArray() }

/** Converts a given [Array] or [Iterable] into an [Iterable], mapping each element. */
@Suppress("UNCHECKED_CAST")
internal fun <T, TResult> Any.toIterableKt(valueMapper: (value: T) -> TResult): List<TResult> =
    when (this) {
        is Array<*> -> (this as Array<T>).map(valueMapper)
        is Iterable<*> -> (this as Iterable<T>).map(valueMapper)
        else -> error("Invalid iterable.")
    }
