/**
 * JavaScript
 * [WeakMap](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WeakMap).
 */
private external class WeakMap<TKey, TValue> {
    fun has(key: TKey): Boolean

    fun get(key: TKey): TValue?

    fun set(key: TKey, value: TValue)

    fun delete(key: TKey): Boolean
}

/**
 * Global cache for all transformations. E.g. stores the mapping between a `Schema` and its
 * corresponding `SchemaJs` so that we don't create multiple JS instances from the same schema.
 */
private val cache = WeakMap<Any?, Any?>()

/**
 * Gets the value associated with [key] from a cache. If the cache contains no such value, then
 * [defaultValue] is called and set in the cache as the value associated with the [key].
 */
@Suppress("UNCHECKED_CAST")
internal fun <TKey : Any, TValue> getOrSetFromCache(key: TKey, defaultValue: () -> TValue): TValue {
    var value = cache.get(key)
    if (value === undefined) {
        value = defaultValue()
        cache.set(key, value)
    }
    return value as TValue
}
