import tech.ostack.kform.AutoValidationStatus
import tech.ostack.kform.DisplayStatus
import tech.ostack.kform.ValidationStatus

/**
 * [Validation status][ValidationStatus] representation for use from JavaScript (`"unvalidated" |
 * "validating" | "validated" | "validatedExceptionally"`).
 */
public typealias ValidationStatusJs = String

/**
 * [Display status][DisplayStatus] representation for use from JavaScript (`"valid" | "error" |
 * "warning"`).
 */
public typealias DisplayStatusJs = String

/**
 * [Auto validation status][AutoValidationStatus] representation for use from JavaScript
 * (`"inactive" | "activeIdle" | "activeRunning"`).
 */
public typealias AutoValidationStatusJs = String

internal fun ValidationStatus.toJs(): ValidationStatusJs =
    toString().replaceFirstChar { it.lowercase() }

internal fun DisplayStatus.toJs(): DisplayStatusJs = toString().replaceFirstChar { it.lowercase() }

internal fun AutoValidationStatus.toJs(): AutoValidationStatusJs =
    toString().replaceFirstChar { it.lowercase() }
